<?php

/*
 *
 * File ini bagian dari:
 *
 * OpenSID
 *
 * Sistem informasi desa sumber terbuka untuk memajukan desa
 *
 * Aplikasi dan source code ini dirilis berdasarkan lisensi GPL V3
 *
 * Hak Cipta 2009 - 2015 Combine Resource Institution (http://lumbungkomunitas.net/)
 * Hak Cipta 2016 - 2024 Perkumpulan Desa Digital Terbuka (https://opendesa.id)
 *
 * Dengan ini diberikan izin, secara gratis, kepada siapa pun yang mendapatkan salinan
 * dari perangkat lunak ini dan file dokumentasi terkait ("Aplikasi Ini"), untuk diperlakukan
 * tanpa batasan, termasuk hak untuk menggunakan, menyalin, mengubah dan/atau mendistribusikan,
 * asal tunduk pada syarat berikut:
 *
 * Pemberitahuan hak cipta di atas dan pemberitahuan izin ini harus disertakan dalam
 * setiap salinan atau bagian penting Aplikasi Ini. Barang siapa yang menghapus atau menghilangkan
 * pemberitahuan ini melanggar ketentuan lisensi Aplikasi Ini.
 *
 * PERANGKAT LUNAK INI DISEDIAKAN "SEBAGAIMANA ADANYA", TANPA JAMINAN APA PUN, BAIK TERSURAT MAUPUN
 * TERSIRAT. PENULIS ATAU PEMEGANG HAK CIPTA SAMA SEKALI TIDAK BERTANGGUNG JAWAB ATAS KLAIM, KERUSAKAN ATAU
 * KEWAJIBAN APAPUN ATAS PENGGUNAAN ATAU LAINNYA TERKAIT APLIKASI INI.
 *
 * @package   OpenSID
 * @author    Tim Pengembang OpenDesa
 * @copyright Hak Cipta 2009 - 2015 Combine Resource Institution (http://lumbungkomunitas.net/)
 * @copyright Hak Cipta 2016 - 2024 Perkumpulan Desa Digital Terbuka (https://opendesa.id)
 * @license   http://www.gnu.org/licenses/gpl.html GPL V3
 * @link      https://github.com/OpenSID/OpenSID
 *
 */

namespace App\Enums;

defined('BASEPATH') || exit('No direct script access allowed');

class SukuEnum extends BaseEnum
{
    public const ACEH                = 'Aceh';
    public const ALAS                = 'Alas';
    public const ALOR                = 'Alor';
    public const AMBON               = 'Ambon';
    public const AMPANA              = 'Ampana';
    public const ANAK_DALAM          = 'Anak Dalam';
    public const ANEUK_JAMEE         = 'Aneuk Jamee';
    public const ARAB_ORANG_HADHRAMI = 'Arab: Orang Hadhrami';
    public const ARU                 = 'Aru';
    public const ASMAT               = 'Asmat';
    public const BARE’E              = 'Bare’e';
    public const BANTEN              = 'Banten';
    public const BESEMAH             = 'Besemah';
    public const BALI                = 'Bali';
    public const BALANTAK            = 'Balantak';
    public const BANGGAI             = 'Banggai';
    public const BADUY               = 'Baduy';
    public const BAJAU               = 'Bajau';
    public const BANJAR              = 'Banjar';
    public const BATAK               = 'Batak';
    public const BATAK_KARO          = 'Batak Karo';
    public const MANDAILING          = 'Mandailing';
    public const ANGKOLA             = 'Angkola';
    public const TOBA                = 'Toba';
    public const PAKPAK              = 'Pakpak';
    public const SIMALUNGUN          = 'Simalungun';
    public const BATIN               = 'Batin';
    public const BAWEAN              = 'Bawean';
    public const BENTONG             = 'Bentong';
    public const BERAU               = 'Berau';
    public const BETAWI              = 'Betawi';
    public const BIMA                = 'Bima';
    public const BOTI                = 'Boti';
    public const BOLANG_MONGONDOW    = 'Bolang Mongondow';
    public const BUGIS               = 'Bugis';
    public const BUNGKU              = 'Bungku';
    public const BURU                = 'Buru';
    public const BUOL                = 'Buol';
    public const BULUNGAN            = 'Bulungan ';
    public const BUTON               = 'Buton';
    public const BONAI               = 'Bonai';
    public const CHAM                = 'Cham ';
    public const CIREBON             = 'Cirebon ';
    public const DAMAL               = 'Damal';
    public const DAMPELES            = 'Dampeles';
    public const DANI                = 'Dani ';
    public const DAIRI               = 'Dairi';
    public const DAYA                = 'Daya ';
    public const DAYAK               = 'Dayak';
    public const DOMPU               = 'Dompu';
    public const DONGGO              = 'Donggo';
    public const DONGGA              = 'Dongga';
    public const DONDO               = 'Dondo ';
    public const DURI                = 'Duri';
    public const EROPA               = 'Eropa ';
    public const FLORES              = 'Flores';
    public const LAMAHOLOT           = 'Lamaholot';
    public const GAYO                = 'Gayo';
    public const GORONTALO           = 'Gorontalo';
    public const GUMAI               = 'Gumai ';
    public const INDIA               = 'India';
    public const JAWA                = 'Jawa';
    public const TENGGER             = 'Tengger';
    public const OSING               = 'Osing ';
    public const SAMIN               = 'Samin ';
    public const JAMBI               = 'Jambi ';
    public const JEPANG              = 'Jepang';
    public const KEI                 = 'Kei';
    public const KAILI               = 'Kaili ';
    public const KAMPAR              = 'Kampar';
    public const KAUR                = 'Kaur ';
    public const KAYU_AGUNG          = 'Kayu Agung';
    public const KERINCI             = 'Kerinci';
    public const KOMERING            = 'Komering ';
    public const KONJO_PEGUNUNGAN    = 'Konjo Pegunungan';
    public const KONJO_PESISIR       = 'Konjo Pesisir';
    public const KOTO                = 'Koto';
    public const KUBU                = 'Kubu';
    public const KULAWI              = 'Kulawi';
    public const KUTAI               = 'Kutai ';
    public const KLUET               = 'Kluet ';
    public const KOREA               = 'Korea ';
    public const KRUI                = 'Krui';
    public const LAUT                = 'Laut,';
    public const LAMPUNG             = 'Lampung';
    public const LEMATANG            = 'Lematang ';
    public const LEMBAK              = 'Lembak';
    public const LINTANG             = 'Lintang';
    public const LOM                 = 'Lom';
    public const LORE                = 'Lore';
    public const LUBU                = 'Lubu';
    public const MORONENE            = 'Moronene';
    public const MADURA              = 'Madura';
    public const MAKASSAR            = 'Makassar';
    public const MAMASA              = 'Mamasa';
    public const MANDA               = 'Manda';
    public const MELAYU              = 'Melayu';
    public const MENTAWAI            = 'Mentawai';
    public const MINAHASA            = 'Minahasa';
    public const PONOSAKAN           = 'Ponosakan';
    public const MINANGKABAU         = 'Minangkabau';
    public const MONGONDOW           = 'Mongondow';
    public const MORI                = 'Mori';
    public const MUKO_MUKO           = 'Muko-Muko';
    public const MUNA                = 'Muna';
    public const MUYU                = 'Muyu';
    public const MEKONGGA            = 'Mekongga';
    public const MORO                = 'Moro';
    public const NIAS                = 'Nias';
    public const NGADA               = 'Ngada ';
    public const OGAN                = 'Ogan';
    public const OCU                 = 'Ocu';
    public const PADOE               = 'Padoe';
    public const PAPUA               = 'Papua';
    public const PALEMBANG           = 'Palembang';
    public const PAMONA              = 'Pamona';
    public const PESISI              = 'Pesisi';
    public const PASIR               = 'Pasir';
    public const PUBIAN              = 'Pubian';
    public const PATTAE              = 'Pattae';
    public const PAKISTANI           = 'Pakistani';
    public const PERANAKAN           = 'Peranakan';
    public const RAWA                = 'Rawa';
    public const REJANG              = 'Rejang';
    public const ROTE                = 'Rote';
    public const RONGGA              = 'Rongga';
    public const ROHINGYA            = 'Rohingya';
    public const SABU                = 'Sabu';
    public const SALUAN              = 'Saluan';
    public const SAMBAS              = 'Sambas';
    public const SANGI               = 'Sangi';
    public const SASAK               = 'Sasak';
    public const SEKAK_BANGKA        = 'Sekak Bangka';
    public const SEKAYU              = 'Sekayu';
    public const SEMENDO             = 'Semendo ';
    public const SERAWAI             = 'Serawai ';
    public const SIMEULUE            = 'Simeulue';
    public const SIGULAI             = 'Sigulai ';
    public const SULUK               = 'Suluk';
    public const SUMBAWA             = 'Sumbawa ';
    public const SUMBA               = 'Sumba';
    public const SUNDA               = 'Sunda';
    public const SUNGKAI             = 'Sungkai ';
    public const TALAU               = 'Talau';
    public const TALANG_MAMAK        = 'Talang Mamak';
    public const TAMIANG             = 'Tamiang ';
    public const TERNATE             = 'Ternate ';
    public const TIDORE              = 'Tidore';
    public const TIDUNG              = 'Tidung';
    public const TIMOR               = 'Timor';
    public const TIONGHOA            = 'Tionghoa';
    public const TOJO                = 'Tojo';
    public const TORAJA              = 'Toraja';
    public const TOLAKI              = 'Tolaki';
    public const TOLI_TOLI           = 'Toli Toli';
    public const TOMINI              = 'Tomini';
    public const UNA_UNA             = 'Una-una ';
    public const ULU                 = 'Ulu';
    public const WOLIO               = 'Wolio';

    /**
     * Override method all()
     */
    public static function all(): array
    {
        return [
            self::ACEH                => 'Aceh',
            self::ALAS                => 'Aceh',
            self::ALOR                => 'NTT',
            self::AMBON               => 'Ambon',
            self::AMPANA              => 'Sulawesi Tengah',
            self::ANAK_DALAM          => 'Jambi',
            self::ANEUK_JAMEE         => 'Aceh',
            self::ARAB_ORANG_HADHRAMI => 'Arab: Orang Hadhrami',
            self::ARU                 => 'Maluku',
            self::ASMAT               => 'Papua',
            self::BARE’E              => 'Bare’e di Kabupaten Tojo Una-Una Tojo dan Tojo Barat',
            self::BANTEN              => 'Banten di Banten',
            self::BESEMAH             => 'Besemah di Sumatera Selatan',
            self::BALI                => "Bali\u{a0}di Bali terdiri dari: Suku Bali Majapahit di sebagian besar Pulau Bali; Suku Bali Aga di Karangasem dan Kintamani",
            self::BALANTAK            => 'Balantak di Sulawesi Tengah',
            self::BANGGAI             => 'Banggai di Sulawesi Tengah (Kabupaten Banggai Kepulauan)',
            self::BADUY               => "Baduy\u{a0}di Banten",
            self::BAJAU               => 'Bajau di Kalimantan Timur',
            self::BANJAR              => 'Banjar di Kalimantan Selatan',
            self::BATAK               => 'Sumatera Utara',
            self::BATAK_KARO          => 'Sumatera Utara',
            self::MANDAILING          => 'Sumatera Utara',
            self::ANGKOLA             => 'Sumatera Utara',
            self::TOBA                => 'Sumatera Utara',
            self::PAKPAK              => 'Sumatera Utara',
            self::SIMALUNGUN          => 'Sumatera Utara',
            self::BATIN               => 'Batin di Jambi',
            self::BAWEAN              => 'Bawean di Jawa Timur (Gresik)',
            self::BENTONG             => 'Bentong di Sulawesi Selatan',
            self::BERAU               => 'Berau di Kalimantan Timur (kabupaten Berau)',
            self::BETAWI              => 'Betawi di Jakarta',
            self::BIMA                => 'Bima NTB (kota Bima)',
            self::BOTI                => 'Boti di kabupaten Timor Tengah Selatan',
            self::BOLANG_MONGONDOW    => 'Bolang Mongondow di Sulawesi Utara (Kabupaten Bolaang Mongondow)',
            self::BUGIS               => "Bugis\u{a0}di Sulawesi Selatan: Orang Bugis Pagatan di Kalimantan Selatan, Kusan Hilir, Tanah Bumbu",
            self::BUNGKU              => 'Bungku di Sulawesi Tengah (Kabupaten Morowali)',
            self::BURU                => 'Buru di Maluku (Kabupaten Buru)',
            self::BUOL                => 'Buol di Sulawesi Tengah (Kabupaten Buol)',
            self::BULUNGAN            => 'Bulungan di Kalimantan Timur (Kabupaten Bulungan)',
            self::BUTON               => 'Buton di Sulawesi Tenggara (Kabupaten Buton dan Kota Bau-Bau)',
            self::BONAI               => 'Bonai di Riau (Kabupaten Rokan Hilir)',
            self::CHAM                => 'Cham di Aceh',
            self::CIREBON             => 'Cirebon di Jawa Barat (Kota Cirebon)',
            self::DAMAL               => 'Damal di Mimika',
            self::DAMPELES            => 'Dampeles di Sulawesi Tengah',
            self::DANI                => 'Dani di Papua (Lembah Baliem)',
            self::DAIRI               => 'Dairi di Sumatera Utara',
            self::DAYA                => 'Daya di Sumatera Selatan',
            self::DAYAK               => "Dayak\u{a0}terdiri dari: Suku Dayak Ahe di Kalimantan Barat; Suku Dayak Bajare di Kalimantan Barat; Suku Dayak Damea di Kalimantan Barat; Suku Dayak Banyadu di Kalimantan Barat; Suku Bakati di Kalimantan Barat; Suku Punan di Kalimantan Tengah; Suku Kanayatn di Kalimantan Barat; Suku Dayak Krio di Kalimantan Barat (Ketapang); Suku Dayak Sungai Laur di Kalimantan Barat (Ketapang); Suku Dayak Simpangh di Kalimantan Barat (Ketapang); Suku Iban di Kalimantan Barat; Suku Mualang di Kalimantan Barat (Sekada",
            self::DOMPU               => 'Dompu NTB (Kabupaten Dompu)',
            self::DONGGO              => 'Donggo, Bima',
            self::DONGGA              => 'Donggala di Sulawesi Tengah',
            self::DONDO               => 'Dondo di Sulawesi Tengah (Kabupaten Toli-Toli)',
            self::DURI                => 'Duri Terletak di bagian utara Kabupaten Enrekang berbatasan dengan Kabupaten Tana Toraja, meliputi tiga kecamatan induk Anggeraja, Baraka, dan Alla di Sulawesi Selatan',
            self::EROPA               => 'Eropa (orang Indo, peranakan Eropa-Indonesia, atau etnik Mestizo)',
            self::FLORES              => 'Flores di NTT (Flores Timur)',
            self::LAMAHOLOT           => 'Lamaholot, Flores Timur, terdiri dari: Suku Wandan, di Solor Timur, Flores Timur; Suku Kaliha, di Solor Timur, Flores Timur; Suku Serang Gorang, di Solor Timur, Flores Timur; Suku Lamarobak, di Solor Timur, Flores Timur; Suku Atanuhan, di Solor Timur, Flores Timur; Suku Wotan, di Solor Timur, Flores Timur; Suku Kapitan Belen, di Solor Timur, Flores Timur',
            self::GAYO                => 'Gayo di Aceh (Gayo Lues Aceh Tengah Bener Meriah Aceh Tenggara Aceh Timur Aceh Tamiang)',
            self::GORONTALO           => 'Gorontalo di Gorontalo (Kota Gorontalo)',
            self::GUMAI               => 'Gumai di Sumatera Selatan (Lahat)',
            self::INDIA               => 'India, terdiri dari: Suku Tamil di Aceh, Sumatera Utara, Sumatera Barat, dan DKI Jakarta; Suku Punjab di Sumatera Utara, DKI Jakarta, dan Jawa Timur; Suku Bengali di DKI Jakarta; Suku Gujarati di DKI Jakarta dan Jawa Tengah; Orang Sindhi di DKI Jakarta dan Jawa Timur; Orang Sikh di Sumatera Utara, DKI Jakarta, dan Jawa Timur',
            self::JAWA                => 'Jawa di Jawa Tengah, Jawa Timur, DI Yogyakarta',
            self::OSING               => 'Osing di Jawa Timur (Banyuwangi)',
            self::JAMBI               => 'Jambi di Jambi (Kota Jambi)',
            self::JEPANG              => 'Jepang di DKI Jakarta, Jawa Timur, dan Bali',
            self::KEI                 => 'Kei di Maluku Tenggara (Kabupaten Maluku Tenggara dan Kota Tual)',
            self::KAILI               => 'Kaili di Sulawesi Tengah (Kota Palu)',
            self::KAMPAR              => 'Kampar',
            self::KAUR                => 'Kaur di Bengkulu (Kabupaten Kaur)',
            self::KAYU_AGUNG          => 'Kayu Agung di Sumatera Selatan',
            self::KERINCI             => 'Kerinci di Jambi (Kabupaten Kerinci)',
            self::KOMERING            => 'Komering di Sumatera Selatan (Kabupaten Ogan Komering Ilir, Baturaja)',
            self::KONJO_PEGUNUNGAN    => 'Konjo Pegunungan, Kabupaten Gowa, Sulawesi Selatan',
            self::KONJO_PESISIR       => 'Konjo Pesisir, Kabupaten Bulukumba, Sulawesi Selatan',
            self::KOTO                => 'Koto di Sumatera Barat',
            self::KUBU                => 'Kubu di Jambi dan Sumatera Selatan',
            self::KULAWI              => 'Kulawi di Sulawesi Tengah',
            self::KUTAI               => 'Kutai di Kalimantan Timur (Kutai Kartanegara)',
            self::KLUET               => 'Kluet di Aceh (Aceh Selatan)',
            self::KOREA               => 'Korea di DKI Jakarta',
            self::KRUI                => 'Krui di Lampung',
            self::LAUT                => 'Laut, Kepulauan Riau',
            self::LAMPUNG             => 'Lampung, terdiri dari: Suku Sungkai di Lampung; Suku Abung di Lampung; Suku Way Kanan di Lampung, Sumatera Selatan dan Bengkulu; Suku Pubian di Lampung; Suku Tulang Bawang di Lampung; Suku Melinting di Lampung; Suku Peminggir Teluk di Lampung; Suku Ranau di Lampung, Sumatera Selatan dan Sumatera Utara; Suku Komering di Sumatera Selatan; Suku Cikoneng di Banten; Suku Merpas di Bengkulu; Suku Belalau di Lampung; Suku Smoung di Lampung; Suku Semaka di Lampung',
            self::LEMATANG            => 'Lematang di Sumatera Selatan',
            self::LEMBAK              => 'Lembak, Kabupaten Rejang Lebong, Bengkulu',
            self::LINTANG             => 'Lintang, Sumatera Selatan',
            self::LOM                 => 'Lom, Bangka Belitung',
            self::LORE                => 'Lore, Sulawesi Tengah',
            self::LUBU                => 'Lubu, daerah perbatasan antara Provinsi Sumatera Utara dan Provinsi Sumatera Barat',
            self::MORONENE            => 'Moronene di Sulawesi Tenggara.',
            self::MADURA              => 'Madura di Jawa Timur (Pulau Madura, Kangean, wilayah Tapal Kuda)',
            self::MAKASSAR            => 'Makassar di Sulawesi Selatan: Kabupaten Gowa, Kabupaten Takalar, Kabupaten Jeneponto, Kabupaten Bantaeng, Kabupaten Bulukumba (sebagian), Kabupaten Sinjai (bagian perbatasan Kab Gowa), Kabupaten Maros (sebagian), Kabupaten Pangkep (sebagian), Kota Makassar',
            self::MAMASA              => 'Mamasa (Toraja Barat) di Sulawesi Barat: Kabupaten Mamasa',
            self::MANDA               => 'Mandar Sulawesi Barat: Polewali Mandar',
            self::MELAYU              => 'Melayu, terdiri dari Suku Melayu Tamiang di Aceh (Aceh Tamiang); Suku Melayu Riau di Riau dan Kepulauan Riau; Suku Melayu Deli di Sumatera Utara; Suku Melayu Jambi di Jambi; Suku Melayu Bangka di Pulau Bangka; Suku Melayu Belitung di Pulau Belitung; Suku Melayu Sambas di Kalimantan Barat',
            self::MENTAWAI            => 'Mentawai di Sumatera Barat (Kabupaten Kepulauan Mentawai)',
            self::MINAHASA            => 'Minahasa di Sulawesi Utara (Kabupaten Minahasa), terdiri 9 subetnik : Suku Babontehu; Suku Bantik; Suku Pasan Ratahan',
            self::PONOSAKAN           => 'Ponosakan; Suku Tonsea; Suku Tontemboan; Suku Toulour; Suku Tonsawang; Suku Tombulu',
            self::MINANGKABAU         => 'Minangkabau, Sumatera Barat',
            self::MONGONDOW           => 'Mongondow, Sulawesi Utara',
            self::MORI                => 'Mori, Kabupaten Morowali, Sulawesi Tengah',
            self::MUKO_MUKO           => 'Muko-Muko di Bengkulu (Kabupaten Mukomuko)',
            self::MUNA                => 'Muna di Sulawesi Tenggara (Kabupaten Muna)',
            self::MUYU                => 'Muyu di Kabupaten Boven Digoel, Papua',
            self::MEKONGGA            => 'Mekongga di Sulawesi Tenggara (Kabupaten Kolaka dan Kabupaten Kolaka Utara)',
            self::MORO                => 'Moro di Kalimantan Barat dan Kalimantan Utara',
            self::NIAS                => 'Nias di Sumatera Utara (Kabupaten Nias, Nias Selatan dan Nias Utara dari dua keturunan Jepang dan Vietnam)',
            self::NGADA               => 'Ngada di NTT: Kabupaten Ngada',
            self::OGAN                => 'Ogan di Sumatera Selatan',
            self::OCU                 => 'Ocu di Kabupaten Kampar, Riau',
            self::PADOE               => 'Padoe di Sulawesi Tengah dan Sulawesi Selatan',
            self::PAPUA               => 'Papua / Irian, terdiri dari: Suku Asmat di Kabupaten Asmat; Suku Biak di Kabupaten Biak Numfor; Suku Dani, Lembah Baliem, Papua; Suku Ekagi, daerah Paniai, Abepura, Papua; Suku Amungme di Mimika; Suku Bauzi, Mamberamo hilir, Papua utara; Suku Arfak di Manokwari; Suku Kamoro di Mimika',
            self::PALEMBANG           => 'Palembang di Sumatera Selatan (Kota Palembang)',
            self::PAMONA              => 'Pamona di Sulawesi Tengah (Kabupaten Poso) dan di Sulawesi Selatan',
            self::PESISI              => 'Pesisi di Sumatera Utara (Tapanuli Tengah)',
            self::PASIR               => 'Pasir di Kalimantan Timur (Kabupaten Pasir)',
            self::PUBIAN              => 'Pubian di Lampung',
            self::PATTAE              => 'Pattae di Polewali Mandar',
            self::PAKISTANI           => 'Pakistani di Sumatera Utara, DKI Jakarta, dan Jawa Tengah',
            self::PERANAKAN           => 'Peranakan (Tionghoa-Peranakan atau Baba Nyonya)',
            self::RAWA                => 'Rawa, Rokan Hilir, Riau',
            self::REJANG              => 'Rejang di Bengkulu (Kabupaten Bengkulu Tengah, Kabupaten Bengkulu Utara, Kabupaten Kepahiang, Kabupaten Lebong, dan Kabupaten Rejang Lebong)',
            self::ROTE                => 'Rote di NTT (Kabupaten Rote Ndao)',
            self::RONGGA              => 'Rongga di NTT Kabupaten Manggarai Timur',
            self::ROHINGYA            => 'Rohingya',
            self::SABU                => 'Sabu di Pulau Sabu, NTT',
            self::SALUAN              => 'Saluan di Sulawesi Tengah',
            self::SAMBAS              => 'Sambas (Melayu Sambas) di Kalimantan Barat: Kabupaten Sambas',
            self::SAMIN               => 'Samin di Jawa Tengah (Blora) dan Jawa Timur (Bojonegoro)',
            self::SANGI               => 'Sangir di Sulawesi Utara (Kepulauan Sangihe)',
            self::SASAK               => "Sasak\u{a0}di NTB, Lombok",
            self::SEKAK_BANGKA        => 'Sekak Bangka',
            self::SEKAYU              => 'Sekayu di Sumatera Selatan',
            self::SEMENDO             => 'Semendo di Bengkulu, Sumatera Selatan (Muara Enim)',
            self::SERAWAI             => 'Serawai di Bengkulu (Kabupaten Bengkulu Selatan dan Kabupaten Seluma)',
            self::SIMEULUE            => 'Simeulue di Aceh (Kabupaten Simeulue)',
            self::SIGULAI             => 'Sigulai di Aceh (Kabupaten Simeulue bagian utara',
            self::SULUK               => 'Suluk di Kalimantan Utara)',
            self::SUMBAWA             => 'Sumbawa Di NTB (Kabupaten Sumbawa)',
            self::SUMBA               => 'Sumba di NTT (Sumba Barat, Sumba Timur)',
            self::SUNDA               => 'Sunda di Jawa Barat, Banten, DKI Jakarta, Lampung, Sumatra Selatan dan Jawa Tengah',
            self::SUNGKAI             => 'Sungkai di Lampung Lampung Utara',
            self::TALAU               => 'Talaud di Sulawesi Utara (Kepulauan Talaud)',
            self::TALANG_MAMAK        => 'Talang Mamak di Riau (Indragiri Hulu)',
            self::TAMIANG             => 'Tamiang di Aceh (Kabupaten Aceh Tamiang)',
            self::TENGGER             => 'Tengger di Jawa Timur (Kabupaten Pasuruan) dan Probolinggo (lereng G. Bromo)',
            self::TERNATE             => 'Ternate di Maluku Utara (Kota Ternate)',
            self::TIDORE              => 'Tidore di Maluku Utara (Kota Tidore)',
            self::TIDUNG              => 'Tidung di Kalimantan Timur (Kabupaten Tanah Tidung)',
            self::TIMOR               => 'Timor di NTT, Kota Kupang',
            self::TIONGHOA            => 'Tionghoa, terdiri dari: Orang Cina Parit di Pelaihari, Tanah Laut, Kalsel; Orang Cina Benteng di Tangerang, Provinsi Banten; Orang Tionghoa Hokkien di Jawa dan Sumatera Utara; Orang Tionghoa Hakka di Belitung dan Kalimantan Barat; Orang Tionghoa Hubei; Orang Tionghoa Hainan; Orang Tionghoa Kanton; Orang Tionghoa Hokchia; Orang Tionghoa Tiochiu',
            self::TOJO                => 'Tojo di Sulawesi Tengah (Kabupaten Tojo Una-Una)',
            self::TORAJA              => 'Toraja di Sulawesi Selatan (Tana Toraja)',
            self::TOLAKI              => 'Tolaki di Sulawesi Tenggara (Kendari)',
            self::TOLI_TOLI           => 'Toli Toli di Sulawesi Tengah (Kabupaten Toli-Toli)',
            self::TOMINI              => 'Tomini di Sulawesi Tengah (Kabupaten Parigi Mouton',
            self::UNA_UNA             => 'Una-una di Sulawesi Tengah (Kabupaten Tojo Una-Una)',
            self::ULU                 => 'Ulu di Sumatera Utara (Mandailing natal)',
            self::WOLIO               => 'Wolio di Sulawesi Tenggara (Buton)',
        ];
    }
}
