tinymce.PluginManager.add("salintemplate", function (editor, url) {
    editor.ui.registry.addMenuButton("salintemplate", {
        text: "Salin Template",
        fetch: function (callback) {
            var items = [];
            var urlSalinTemplate = editor.getElement().getAttribute('data-urlsalintemplate') ?? 'surat_master'
            var ajaxUrl = SITE_URL + urlSalinTemplate +"/salin_template/" + editor.getElement().getAttribute('data-salintemplate')
            $.ajax({
                type: "GET",
                url: ajaxUrl,
                    
                dataType: "json",
                processData: true,
                success: function (response) {
                    $.each(response, function (key, value) {
                        var menuItem = {
                            type: "nestedmenuitem",
                            text: value.nama,
                            getSubmenuItems: function () {
                                return [
                                    {
                                        type: "menuitem",
                                        text: "Template Sistem",
                                        onAction: function () {
                                            setContent(
                                                editor,
                                                value.template.sistem,
                                                "Template Sistem Tidak Tersedia."
                                            );
                                        },
                                    },
                                    {
                                        type: "menuitem",
                                        text: "Template Desa",
                                        onAction: function () {
                                            setContent(
                                                editor,
                                                value.template.desa,
                                                "Template Desa Tidak Tersedia."
                                            );
                                        },
                                    },
                                ];
                            },
                        };

                        items.push(menuItem);
                    });

                    callback(items);
                },

                error: function (xhr, status, error) {
                    notifEditor("Error! " + xhr.status + "\n" + error, "error");
                },
            });
        },
    });
});
