<?php defined('BASEPATH') || exit('No direct script access allowed'); ?>

<div class="body-area">
	<div class="row">
	<div class="col-md-12">
		<?php $this->load->view("$folder_themes/partials/menu_head"); ?>
	</div>
	</div>	
	<div class="row">
	<div class="col-md-12">
		<div class="margin-page">
		<div class="headingpage difle-c">
			<img src="<?= base_url("$this->theme_folder/$this->theme/assets/images/pngfile/gerai.png") ?>"/>
			<h1>Gerai Koperasi</h1>
		</div>
		</div>
	</div>
	</div>
	<div class="column-100 openpage">
		<div class="margin-page">
			<div class="sticky-section">
				<div class="stickyside">
					<div class="stickyside-top">
						<div class="filterleft">
							<div class="filter-info mt-15 desktop-only">
								<img src="<?= base_url("$this->theme_folder/$this->theme/assets/images/pngfile/head-gerai.png") ?>"/>
								<p>Filter produk berdasarkan kategori yang tersedia atau lakukan pencarian dengan kata kunci</p>
							</div>
							<form method="get" id="filter">
								<div class="form-change mt-15">
								<select class="form-control select2" id="id_kategori" name="id_kategori" onchange="$('#filter').submit();">
									<option selected value="">Semua Kategori</option>
									<?php foreach ($kategori as $kategori_item) : ?>
									<option value="<?= $kategori_item->id ?>" <?= selected($id_kategori, $kategori_item->id) ?>><?= $kategori_item->kategori ?></option>
									<?php endforeach; ?>
									</select>
								</div>	
								<div class="form-change mt-15">
									<input type="text" name="keyword" maxlength="50" class="form-control" value="<?= e($keyword); ?>" placeholder="Cari Produk">
								</div>
								<div class="form-change mt-15 custombtn">
									<button type="submit" class="btn btnbig warna1 btnblock difle-c"><p>Cari</p></button>
								</div>
								<?php if (e($keyword)): ?>
								<div class="form-change mt-15 difle-l custombtn">
									<a href="<?=site_url('lapak')?>" class="btn btnbig btnblock warna1 difle-c"><p>Tampilkan Semua</p></a>
								</div>
								<?php endif; ?>
							</form>
						</div>
					</div>
				</div>
				<div class="stickymain">
					<div class="stickymain-margin2 mt-15">
						<?php if ($produk): ?>
							<div class="grid-section mlr-min-10">
							<?php foreach ($produk as $in => $pro): ?>
							<?php $foto = json_decode($pro->foto); ?>
								<div class="lapak-colpage displaygrid">
									<div class="aligntop">
									<div class="relhid p10">	
										<?php if ($pro->foto): ?>
											<div id="foto-produk-<?= $in; ?>" class="carousel slide" data-ride="carousel">
												<div class="carousel-inner">
												<?php for ($i = 0; $i < $this->setting->banyak_foto_tiap_produk; $i++): ?>
												<?php if ($foto[$i]): ?>
													<div class="item <?= jecho($i, 0, 'active'); ?>">
													<?php if (is_file(LOKASI_PRODUK . $foto[$i])): ?>
														<div class="lapak-image imagefull hovcontent">
														<a href="<?= base_url(LOKASI_PRODUK . $foto[$i]); ?>"  data-fancybox="images" data-caption="Foto <?= ($i+1); ?>">
															<img src="<?= base_url(LOKASI_PRODUK . $foto[$i]); ?>" alt="Foto <?= ($i+1); ?>">
														</a>	
														</div>
													<?php else: ?>
														<div class="lapak-image imagefull">
															<img src="<?= base_url("$this->theme_folder/$this->theme/assets/images/no-image.jpg") ?>"/>
														</div>
													<?php endif; ?>
													</div>
												<?php endif; ?>
												<?php endfor; ?>
												</div>
											</div>	
										<?php else: ?>
											<div class="lapak-image imagefull">
												<img src="<?= base_url("$this->theme_folder/$this->theme/assets/images/no-image.jpg") ?>"/>
											</div>
										<?php endif; ?>
										<div class="price difle-c">
											<?php $harga_potongan = ($pro->tipe_potongan == 1) ? ($pro->harga * ($pro->potongan / 100)) : $pro->potongan; ?>
											<p>
												<?php if ($pro->potongan != 0): ?>
													<font class="discount"><?= rupiah($pro->harga); ?></font>
												<?php endif; ?>
											</p>
											<p><?= rupiah($pro->harga - $harga_potongan); ?></p>	
										</div>
										<div class="product-title p15"><h2><?= $pro->nama; ?></h2></div>
									</div>
									</div>
									<div class="alignbottom mb15 custombtn">
									<div class="relhid p10">
										<h3>PENYEDIA : <?= $pro->pelapak; ?></h3>
										<div class="difle-c">
										<a class="btn btnsmall bgviola difle-c" style="margin:0 2px!important;" data-remote="false" data-toggle="modal" data-target="#detail<?= $in; ?>" title="Detail" data-title="Detail"><i class="fa fa fa-exclamation"></i><p>Detail</p></a>
										<?php if ($pro->telepon): ?>
											<?php $pesan = strReplaceArrayRecursive(['[nama_produk]' => $pro->nama, '[link_web]' => base_url('lapak'), '<br />' => "%0A"], nl2br($this->setting->pesan_singkat_wa)); ?>
											<a class="btn btnsmall backg-orange difle-c" style="margin:0 2px!important;" href="https://api.whatsapp.com/send?phone=<?=format_telpon($pro->telepon); ?>&amp;text=<?= $pesan; ?>" rel="noopener noreferrer" target="_blank" title="WhatsApp"><i class="fa fa-whatsapp"></i><p>Order</p></a>
										<?php endif; ?>
										<a class="btn btnsmall backg-blue difle-c" style="margin:0 2px!important;" data-remote="false" data-toggle="modal" data-target="#map-modal" title="Lokasi" data-lat="<?= $pro->lat?>" data-lng="<?= $pro->lng?>" data-zoom="<?= $pro->zoom?>" data-title="Lokasi Pelapak (<?= $pro->pelapak?>)"><i class="fa fa fa-map-marker"></i><p>Lokasi</p></a>
										</div>
									</div>
								</div>
								</div>
								<div class='modal center fade' id="detail<?= $in; ?>" tabindex='-1' role='dialog' aria-labelledby='myModalLabel' aria-hidden='true'>
									<div class="modal-dialog bggrey3" role="document" style="border-radius:10px;overflow:hidden;">
										<div class="modalhead difle-l">
												<h1>Detail Lapak</h1>
												<div class='right-close difle-c' data-dismiss='modal' aria-hidden='true'>
												<svg viewBox="0 0 24 24"><path d="M19,6.41L17.59,5L12,10.59L6.41,5L5,6.41L10.59,12L5,17.59L6.41,19L12,13.41L17.59,19L19,17.59L13.41,12L19,6.41Z" /></svg>
												</div>
											</div>
										<div class="inner-modal absfull">
											<div class="scrollbar" id="style-3">
											<div class="scrollbar-pd" style="padding-bottom:100px;">
												<div class="detail-lapak">
												<h1><?= $pro->nama; ?></h1>
												<p><?= nl2br(e($pro->deskripsi)); ?></p>
												</div>
											</div>
											</div>
										</div>	
									</div>
								</div>
							<?php endforeach; ?>	
							</div>
							<div class="row mt-15">
							<div class="col-md-12">
							<?php $this->load->view("$folder_themes/commons/page"); ?>
							</div>
							</div>
							
							<div class='modal center fade' id="map-modal" tabindex='-1' role='dialog' aria-labelledby='myModalLabel' aria-hidden='true'>
								<div class='modal-dialog'>
									<div class='modal-content'>
										<div class='header-modal difle-l'>
											<h1>Lokasi</h1>
											<div class='right-close difle-c' data-dismiss='modal' aria-hidden='true'>
											<svg viewBox="0 0 24 24"><path d="M19,6.41L17.59,5L12,10.59L6.41,5L5,6.41L10.59,12L5,17.59L6.41,19L12,13.41L17.59,19L19,17.59L13.41,12L19,6.41Z" /></svg>
											</div>
										</div>
										<div class="modal-body">
										</div>
									</div>
								</div>
							</div>
						<?php else: ?>
							<div class="lapak-empty mt-15">
								<h2>Mohon Maaf,<br/>data Produk/Barang/Jasa tidak tersedia</h2>
								<div class="empty-image">
									<img src="<?= base_url("$this->theme_folder/$this->theme/assets/images/pngfile/head-gerai.png") ?>"/>
								</div>
							</div>
						<?php endif ?>	
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<script type="text/javascript">
	$(document).ready(function() {
		$(document).on('shown.bs.modal','#map-modal', function(event) {
			let link = $(event.relatedTarget);
			let title = link.data('title');
			let modal = $(this);
			modal.find('.modal-title').text(title);
			modal.find('.modal-body').html("<div id='map' style='width: 100%;'></div>");

			let posisi = [link.data('lat'), link.data('lng')];
			let zoom = link.data('zoom');
			let logo = L.icon({
				iconUrl: "<?= asset('images/gis/point/fastfood.png'); ?>",
			});
			
			$("#lat").val(link.data('lat'));
			$("#lng").val(link.data('lng'));

			var options = {
				maxZoom: <?= setting('max_zoom_peta') ?>,
				minZoom: <?= setting('min_zoom_peta') ?>,
			};

			pelapak = L.map('map', options).setView(posisi, zoom);
			getBaseLayers(pelapak, "<?= setting('mapbox_key') ?>", "<?= setting('jenis_peta') ?>");
			pelapak.addLayer(new L.Marker(posisi, {icon:logo}));
		});
	});
</script>