<?php defined('BASEPATH') || exit('No direct script access allowed'); ?>

<script type="text/javascript">
    let chart;
    const rawData = Object.values(<?= json_encode($stat) ?>);
    const type = '<?= $default_chart_type ?? 'pie' ?>';
    const legend = Boolean(<?= (bool)$tipe ?>);
    let categories = [];
    let data = [];
    let i = 1;
    let status_tampilkan = true;
    for (const stat of rawData) {
        if (stat.nama !== 'TOTAL' && stat.nama !== 'JUMLAH' && stat.nama != 'PENERIMA') {
            let filteredData = [stat.nama, parseInt(stat.jumlah)];
            categories.push(i);
            data.push(filteredData);
            i++;
        }
    }

    function tampilkan_nol(tampilkan = false) {
        if (tampilkan) {
            $(".nol").parent().show();
        } else {
            $(".nol").parent().hide();
        }
    }

    function toggle_tampilkan() {
        $('#showData').click();
        tampilkan_nol(status_tampilkan);
        status_tampilkan = !status_tampilkan;
        if (status_tampilkan) $('#tampilkan').text('Tampilkan Nol');
        else $('#tampilkan').text('Sembunyikan Nol');
    }

    function switchType(obj){
        var chartType = chart_penduduk.series[0].type;
        chart_penduduk.series[0].update({
            type: (chartType === 'pie') ? 'column' : 'pie'
        });
        $(obj).toggleClass('btn-primary btn-default')
        $(obj).siblings().toggleClass('btn-primary btn-default')
    }

    $(document).ready(function () {
        tampilkan_nol(false);
        if (<?=$this->setting->statistik_chart_3d?>) {
            chart_penduduk = new Highcharts.Chart({
                chart: {
                    renderTo: 'container',
                    options3d: {
                        enabled: true,
                        alpha: 45
                    }
                },
                title: 0,
                yAxis: {
                    showEmpty: false,
                },
                xAxis: {
                    categories: categories,
                },
                plotOptions: {
                    series: {
                        colorByPoint: true
                    },
                    column: {
                        pointPadding: -0.1,
                        borderWidth: 0,
                        showInLegend: false,
                        depth: 45
                    },
                    pie: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        showInLegend: true,
                        depth: 45,
                        innerSize: 70
                    }
                },
                legend: {
                    enabled: legend
                },
                series: [{
                    type: type,
                    name: 'Jumlah Populasi',
                    shadow: 1,
                    border: 1,
                    data: data
                }]
            });
        } else {
            chart_penduduk = new Highcharts.Chart({
                chart: {
                    renderTo: 'container'
                },
                title: 0,
                yAxis: {
                    showEmpty: false,
                },
                xAxis: {
                    categories: categories,
                },
                plotOptions: {
                    series: {
                        colorByPoint: true
                    },
                    column: {
                        pointPadding: -0.1,
                        borderWidth: 0,
                        showInLegend: false,
                    },
                    pie: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        showInLegend: true,
                    }
                },
                legend: {
                    enabled: legend
                },
                series: [{
                    type: type,
                    name: 'Jumlah Populasi',
                    shadow: 1,
                    border: 1,
                    data: data
                }]
            });
        }

        $('#showData').click(function () {
            $('tr.lebih').show();
            $('#showData').hide();
            tampilkan_nol(false);
        });

    });
</script>

<div class="body-area">
	<div class="row">
	<div class="col-md-12">
		<?php $this->load->view("$folder_themes/partials/menu_head"); ?>
	</div>
	</div>	
	<div id="printing">
	<div class="printonly">
		<?php $this->load->view("$folder_themes/support/print_header"); ?>
	</div>
	<div class="row no-print">
	<div class="col-md-12">
		<div class="margin-page">
		<div class="headingpage difle-c">
			<img src="<?= base_url("$this->theme_folder/$this->theme/assets/images/pngfile/statistik.png") ?>"/>
			<h1>Statistik</h1>
		</div>
		</div>
	</div>
	</div>
	<div class="column-100 openpage">
		<div class="margin-page">
			<div class="head-title difle-c" style="text-align:center;">
				<h1>Statistik Anggota Berdasarkan <?=$heading?></h1>
			</div>
			<div class="no-print">
				<div class="difle-c mb-15">
					<a class="btn btnsmall backg-orange difle-c <?= ($tipe==1) ? 'bgviola' : 'bgpink' ?>" onclick="switchType();" style="margin:0 3px!important;">
					<svg viewBox="0 0 24 24"><path d="M17.65,6.35C16.2,4.9 14.21,4 12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20C15.73,20 18.84,17.45 19.73,14H17.65C16.83,16.33 14.61,18 12,18A6,6 0 0,1 6,12A6,6 0 0,1 12,6C13.66,6 15.14,6.69 16.22,7.78L13,11H20V4L17.65,6.35Z" /></svg><p>Ganti Format</p>
					</a>
					<a class="btn btnsmall bgviola difle-c" href="javascript:printDiv('printing');" title='Cetak' style="margin:0 3px!important;">
					<svg viewBox="0 0 24 24"><path d="M19 8C20.66 8 22 9.34 22 11V17H18V21H6V17H2V11C2 9.34 3.34 8 5 8H6V3H18V8H19M8 5V8H16V5H8M16 19V15H8V19H16M18 15H20V11C20 10.45 19.55 10 19 10H5C4.45 10 4 10.45 4 11V15H6V13H18V15M19 11.5C19 12.05 18.55 12.5 18 12.5C17.45 12.5 17 12.05 17 11.5C17 10.95 17.45 10.5 18 10.5C18.55 10.5 19 10.95 19 11.5Z" /></svg><p>Print</p>
					</a>
				</div>
				<?php if(isset($list_tahun)): ?>
				<div class="tahun difle-c mt-15">
					<label style="margin:0 10px 0 0;">Tahun: </label>
					<select class="form-control" id="tahun" name="tahun">
						<option selected="" value="">Semua</option>
						<?php foreach ($list_tahun as $item_tahun): ?>
						<option <?= $item_tahun == ($selected_tahun ?? NULL) ? 'selected' : '' ?> value="<?= $item_tahun ?>"><?= $item_tahun ?></option>
						<?php endforeach ?>
					</select>
				</div>
				<?php endif ?>	
			</div>
			<div id="container"></div>
			
			<div class="mt-15">
				<div class="table-responsive" style="border:none !important;">
					<table class="table table-striped" style="min-width:100% !important;">
						<thead>
					<tr>
						<th rowspan="2">Kode</th>
						<th rowspan="2" style='text-align:left;'>Kelompok</th>
						<th colspan="2">Jumlah</th>
						<th colspan="2">Laki-laki</th>
						<th colspan="2">Perempuan</th>
					</tr>
					<tr>
						<th style='text-align:right'>n</th><th style='text-align:right'>%</th>
						<th style='text-align:right'>n</th><th style='text-align:right'>%</th>
						<th style='text-align:right'>n</th><th style='text-align:right'>%</th>
					</tr>
				</thead>
						<tbody>
							<?php $i=0; $l=0; $p=0; $hide=""; $h=0; $jm1=1; $jm = count($stat ?? []); ?>
					<?php foreach ($stat as $data):?>
						<?php $jm1++; if (1):?>
							<?php $h++; if ($h > 12 AND $jm > 10): $hide="lebih"; ?>
							<?php endif;?>
							<tr class="<?=$hide?>">
								<td class="angka">
									<?php if ($jm1 > $jm - 2):?>
										<?=$data['no']?>
									<?php else:?>
										<?=$h?>
									<?php endif;?>
								</td>
								<td><?=$data['nama']?></td>
								<td class="angka <?php ($jm1 <= $jm - 2) and ($data['jumlah'] == 0) and print('nol')?>"><?=$data['jumlah']?></td>
								<td class="angka"><?=$data['persen']?></td>
								<td class="angka"><?=$data['laki']?></td>
								<td class="angka"><?=$data['persen1']?></td>
								<td class="angka"><?=$data['perempuan']?></td>
								<td class="angka"><?=$data['persen2']?></td>
							</tr>
							<?php $i += $data['jumlah'];?>
							<?php $l += $data['laki']; $p += $data['perempuan'];?>
						<?php endif;?>
					<?php endforeach;?>
						</tbody>
					</table>
					<div class="difle-c mt15"><p>Diperbarui pada : <?= tgl_indo($last_update); ?></p></div>
					<div class="no-print">
						<div class="difle-c mt-15">
							<!--
							<?php if($hide=="lebih"):?>
								<button class='btn btn-small bgviola difle-c' id='showData' style='margin:0 2px;'><p>Selengkapnya...</p></button>
							<?php endif;?>
							-->
							<button id='tampilkan' onclick="toggle_tampilkan();" class="btn btnmed warna1 difle-c" style='margin:0 2px;'><p>Tampilkan Nol</p></button>
						</div>
					</div>
				</div>
				<?php if ($this->setting->daftar_penerima_bantuan && $bantuan): ?>
					<section class="content">
						<div class="row">
							<div class="col-md-12">
								<input id="stat" type="hidden" value="<?=$st?>">
								<div class="box box-info">
									<div class="box-header with-border" style="margin-bottom: 15px;">
										<h2 class="post_titile">Daftar <?= $heading ?></h2>
									</div>
									<div class="table-responsive">
										<table class="table table-striped table-bordered" id="peserta_program">
											<thead>
												<tr>
													<th>No</th>
													<th>Program</th>
													<th>Nama Peserta</th>
													<th>Alamat</th>
												</tr>
											</thead>
											<tfoot>
											</tfoot>
										</table>
									</div>
								</div>
							</div>
						</div>
					</section>

					<script type="text/javascript">
					$(document).ready(function() {

						var url = "<?= site_url('first/ajax_peserta_program_bantuan') ?>";
						table = $('#peserta_program').DataTable({
							'processing': true,
							'serverSide': true,
							"pageLength": 10,
							'order': [],
							"ajax": {
								"url": url,
								"type": "POST",
								"data": {stat: $('#stat').val()}
							},
							//Set column definition initialisation properties.
							"columnDefs": [
								{
									"targets": [ 0, 3 ], //first column / numbering column
									"orderable": false, //set not orderable
								},
							],
							'language': {
								'url': BASE_URL + '/assets/bootstrap/js/dataTables.indonesian.lang'
							},
							'drawCallback': function (){
								$('.dataTables_paginate > .pagination').addClass('pagination-sm no-margin');
							}
						});

					} );
					</script>
				<?php endif ?>
			</div>
		</div>
	</div>	
	</div>	
</div>	
<?php $this->load->view("$folder_themes/support/print"); ?>