<?php

/*
 *
 * File ini bagian dari:
 *
 * OpenSID
 *
 * Sistem informasi desa sumber terbuka untuk memajukan desa
 *
 * Aplikasi dan source code ini dirilis berdasarkan lisensi GPL V3
 *
 * Hak Cipta 2009 - 2015 Combine Resource Institution (http://lumbungkomunitas.net/)
 * Hak Cipta 2016 - 2024 Perkumpulan Desa Digital Terbuka (https://opendesa.id)
 *
 * Dengan ini diberikan izin, secara gratis, kepada siapa pun yang mendapatkan salinan
 * dari perangkat lunak ini dan file dokumentasi terkait ("Aplikasi Ini"), untuk diperlakukan
 * tanpa batasan, termasuk hak untuk menggunakan, menyalin, mengubah dan/atau mendistribusikan,
 * asal tunduk pada syarat berikut:
 *
 * Pemberitahuan hak cipta di atas dan pemberitahuan izin ini harus disertakan dalam
 * setiap salinan atau bagian penting Aplikasi Ini. Barang siapa yang menghapus atau menghilangkan
 * pemberitahuan ini melanggar ketentuan lisensi Aplikasi Ini.
 *
 * PERANGKAT LUNAK INI DISEDIAKAN "SEBAGAIMANA ADANYA", TANPA JAMINAN APA PUN, BAIK TERSURAT MAUPUN
 * TERSIRAT. PENULIS ATAU PEMEGANG HAK CIPTA SAMA SEKALI TIDAK BERTANGGUNG JAWAB ATAS KLAIM, KERUSAKAN ATAU
 * KEWAJIBAN APAPUN ATAS PENGGUNAAN ATAU LAINNYA TERKAIT APLIKASI INI.
 *
 * @package   OpenSID
 * @author    Tim Pengembang OpenDesa
 * @copyright Hak Cipta 2009 - 2015 Combine Resource Institution (http://lumbungkomunitas.net/)
 * @copyright Hak Cipta 2016 - 2024 Perkumpulan Desa Digital Terbuka (https://opendesa.id)
 * @license   http://www.gnu.org/licenses/gpl.html GPL V3
 * @link      https://github.com/OpenSID/OpenSID
 *
 */

defined('BASEPATH') || exit('No direct script access allowed');

require_once 'donjo-app/models/Inventaris_tanah_model.php';

class Inventaris_kontruksi_model extends Inventaris_tanah_model
{
    protected $table        = 'inventaris_kontruksi';
    protected $table_mutasi = 'mutasi_inventaris_kontruksi';
    protected $mutasi_key   = 'id_inventaris_kontruksi';

    public function list_inventaris()
    {
        $this->config_id();

        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where($this->table . '.visible', 1);

        return $this->db->get()->result();
    }

    protected function scope_select()
    {
        $this->db
            ->select("{$this->table_mutasi}.id as id")
            ->select("{$this->table_mutasi}.*")
            ->select("{$this->table}.nama_barang")
            ->select("{$this->table}.kode_barang")
            ->select("{$this->table}.tanggal_dokument");
    }

    protected function scope_filter($tahun)
    {
        if ($tahun != 1) {
            $this->db->where('year(tanggal_dokument)', $tahun);
        }
    }

    protected function scope_order()
    {
        $this->db->order_by('year(tanggal_dokument)', 'asc');
    }
}
