<?php

/*
 *
 * File ini bagian dari:
 *
 * OpenSID
 *
 * Sistem informasi desa sumber terbuka untuk memajukan desa
 *
 * Aplikasi dan source code ini dirilis berdasarkan lisensi GPL V3
 *
 * Hak Cipta 2009 - 2015 Combine Resource Institution (http://lumbungkomunitas.net/)
 * Hak Cipta 2016 - 2024 Perkumpulan Desa Digital Terbuka (https://opendesa.id)
 *
 * Dengan ini diberikan izin, secara gratis, kepada siapa pun yang mendapatkan salinan
 * dari perangkat lunak ini dan file dokumentasi terkait ("Aplikasi Ini"), untuk diperlakukan
 * tanpa batasan, termasuk hak untuk menggunakan, menyalin, mengubah dan/atau mendistribusikan,
 * asal tunduk pada syarat berikut:
 *
 * Pemberitahuan hak cipta di atas dan pemberitahuan izin ini harus disertakan dalam
 * setiap salinan atau bagian penting Aplikasi Ini. Barang siapa yang menghapus atau menghilangkan
 * pemberitahuan ini melanggar ketentuan lisensi Aplikasi Ini.
 *
 * PERANGKAT LUNAK INI DISEDIAKAN "SEBAGAIMANA ADANYA", TANPA JAMINAN APA PUN, BAIK TERSURAT MAUPUN
 * TERSIRAT. PENULIS ATAU PEMEGANG HAK CIPTA SAMA SEKALI TIDAK BERTANGGUNG JAWAB ATAS KLAIM, KERUSAKAN ATAU
 * KEWAJIBAN APAPUN ATAS PENGGUNAAN ATAU LAINNYA TERKAIT APLIKASI INI.
 *
 * @package   OpenSID
 * @author    Tim Pengembang OpenDesa
 * @copyright Hak Cipta 2009 - 2015 Combine Resource Institution (http://lumbungkomunitas.net/)
 * @copyright Hak Cipta 2016 - 2024 Perkumpulan Desa Digital Terbuka (https://opendesa.id)
 * @license   http://www.gnu.org/licenses/gpl.html GPL V3
 * @link      https://github.com/OpenSID/OpenSID
 *
 */

use App\Enums\OfflineModeEnum;
use App\Libraries\TinyMCE;
use App\Models\SettingAplikasi as SettingAplikasiModel;
use Illuminate\Support\Facades\DB;

defined('BASEPATH') || exit('No direct script access allowed');

class SettingAplikasi extends CI_Model
{
    public function getData()
    {
        return [
            [
                'judul'      => 'Sebutan Kabupaten',
                'key'        => 'sebutan_kabupaten',
                'value'      => 'kabupaten',
                'keterangan' => 'Pengganti sebutan wilayah kabupaten',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Sebutan Kabupaten Singkat',
                'key'        => 'sebutan_kabupaten_singkat',
                'value'      => 'kab.',
                'keterangan' => 'Pengganti sebutan singkatan wilayah kabupaten',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Sebutan Kecamatan',
                'key'        => 'sebutan_kecamatan',
                'value'      => 'kecamatan',
                'keterangan' => 'Pengganti sebutan wilayah kecamatan',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Sebutan Kecamatan Singkat',
                'key'        => 'sebutan_kecamatan_singkat',
                'value'      => 'kec.',
                'keterangan' => 'Pengganti sebutan singkatan wilayah kecamatan',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Sebutan Desa',
                'key'        => 'sebutan_desa',
                'value'      => 'desa',
                'keterangan' => 'Pengganti sebutan wilayah desa',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Sebutan Dusun',
                'key'        => 'sebutan_dusun',
                'value'      => 'dusun',
                'keterangan' => 'Pengganti sebutan wilayah dusun',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Sebutan Camat',
                'key'        => 'sebutan_camat',
                'value'      => 'camat',
                'keterangan' => 'Pengganti sebutan jabatan camat',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Website Title',
                'key'        => 'website_title',
                'value'      => 'Website Resmi',
                'keterangan' => 'Judul tab browser modul web',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'web',
            ],
            [
                'judul'      => 'Login Title',
                'key'        => 'login_title',
                'value'      => 'OpenSID',
                'keterangan' => 'Judul tab browser halaman login modul administrasi',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Admin Title',
                'key'        => 'admin_title',
                'value'      => 'Sistem Informasi',
                'keterangan' => 'Judul tab browser modul administrasi',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Web Theme',
                'key'        => 'web_theme',
                'value'      => config_item('web_theme') ?: 'natra',
                'keterangan' => 'Tema penampilan modul web',
                'jenis'      => 'option',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'web',
            ],
            [
                'judul'      => 'Offline Mode',
                'key'        => 'offline_mode',
                'value'      => OfflineModeEnum::PUBLIK,
                'keterangan' => 'Apakah modul web akan ditampilkan atau tidak',
                'jenis'      => 'option',
                'option'     => OfflineModeEnum::allToJson(),
                'attribute'  => null,
                'kategori'   => 'web',
            ],
            [
                'judul'      => 'Enable Track',
                'key'        => 'enable_track',
                'value'      => '1',
                'keterangan' => 'Apakah akan mengirimkan data statistik ke tracker',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Mapbox Key',
                'key'        => 'mapbox_key',
                'value'      => null,
                'keterangan' => 'Mapbox API Key untuk peta',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'web',
            ],
            [
                'judul'      => 'Libreoffice Path',
                'key'        => 'libreoffice_path',
                'value'      => null,
                'keterangan' => 'Path tempat instal libreoffice di server SID',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Sumber Gambar Slider',
                'key'        => 'sumber_gambar_slider',
                'value'      => '2',
                'keterangan' => 'Sumber gambar slider besar',
                'jenis'      => 'option',
                'option'     => json_encode([
                    '1' => 'Gambar utama artikel terbaru',
                    '2' => 'Gambar utama artikel terbaru yang masuk ke slider atas',
                    '3' => 'Gambar dalam album galeri yang dimasukkan ke slider',
                ]),
                'attribute' => null,
                'kategori'  => 'web',
            ],
            [
                'judul'      => 'Sebutan Singkatan Kadus',
                'key'        => 'sebutan_singkatan_kadus',
                'value'      => 'Kepala Dusun',
                'keterangan' => 'Sebutan singkatan jabatan kepala dusun',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Current Version',
                'key'        => 'current_version',
                'value'      => currentVersion(),
                'keterangan' => 'Versi sekarang untuk migrasi',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => 'class="" disabled',
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Timezone',
                'key'        => 'timezone',
                'value'      => 'Asia/Jakarta',
                'keterangan' => 'Zona waktu perekaman waktu dan tanggal',
                'jenis'      => 'option',
                'option'     => json_encode([
                    'Asia/Jakarta'  => 'Asia/Jakarta',
                    'Asia/Makassar' => 'Asia/Makassar',
                    'Asia/Jayapura' => 'Asia/Jayapura',
                ]),
                'attribute' => null,
                'kategori'  => 'sistem',
            ],
            [
                'judul'      => 'Web Artikel Per Page',
                'key'        => 'web_artikel_per_page',
                'value'      => '8',
                'keterangan' => 'Jumlah artikel dalam satu halaman',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => 'class="int"',
                'kategori'   => 'web_theme',
            ],
            [
                'judul'      => 'Penomoran Surat',
                'key'        => 'penomoran_surat',
                'value'      => '2',
                'keterangan' => 'Penomoran surat mulai dari satu (1) setiap tahun',
                'jenis'      => 'option',
                'option'     => json_encode([
                    '1' => 'Nomor berurutan untuk masing-masing surat masuk dan keluar; dan untuk semua surat layanan',
                    '2' => 'Nomor berurutan untuk masing-masing surat masuk dan keluar; dan untuk setiap surat layanan dengan jenis yang sama',
                    '3' => 'Nomor berurutan untuk keseluruhan surat layanan, masuk dan keluar',
                ]),
                'attribute' => null,
                'kategori'  => 'sistem',
            ],
            [
                'judul'      => 'Dashboard Program Bantuan',
                'key'        => 'dashboard_program_bantuan',
                'value'      => '1',
                'keterangan' => 'ID program bantuan yang ditampilkan di dashboard',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => 'class="int"',
                'kategori'   => 'dashboard',
            ],
            [
                'judul'      => 'Panjang Nomor Surat',
                'key'        => 'panjang_nomor_surat',
                'value'      => null,
                'keterangan' => "Nomor akan diisi '0' di sebelah kiri, kalau perlu",
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => 'class="int"',
                'kategori'   => 'surat',
            ],
            [
                'judul'      => 'Warna Tema Admin',
                'key'        => 'warna_tema_admin',
                'value'      => 'skin-purple',
                'keterangan' => 'Warna dasar tema komponen Admin',
                'jenis'      => 'option',
                'option'     => json_encode([
                    'skin-blue'         => 'Biru',
                    'skin-blue-light'   => 'Biru Terang',
                    'skin-black'        => 'Hitam',
                    'skin-black-light'  => 'Hitam Terang',
                    'skin-red'          => 'Merah',
                    'skin-red-light'    => 'Merah Terang',
                    'skin-yellow'       => 'Kuning',
                    'skin-yellow-light' => 'Kuning Terang',
                    'skin-purple'       => 'Ungu',
                    'skin-purple-light' => 'Ungu Terang',
                    'skin-green'        => 'Hijau',
                    'skin-green-light'  => 'Hijau Terang',
                ]),
                'attribute' => null,
                'kategori'  => 'sistem',
            ],
            [
                'judul'      => 'Format Nomor Surat',
                'key'        => 'format_nomor_surat',
                'value'      => '[kode_surat]/[nomor_surat, 3]/[kode_desa]/[bulan_romawi]/[tahun]',
                'keterangan' => 'Fomat penomoran surat',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'format_surat',
            ],
            [
                'judul'      => 'Penggunaan Server',
                'key'        => 'penggunaan_server',
                'value'      => '1 ',
                'keterangan' => 'Setting penggunaan server',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => 'class="int"',
                'kategori'   => 'hidden',
            ],
            [
                'judul'      => 'Daftar Penerima Bantuan',
                'key'        => 'daftar_penerima_bantuan',
                'value'      => '1',
                'keterangan' => 'Apakah akan tampilkan daftar penerima bantuan di statistik halaman muka',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'conf_web',
            ],
            [
                'judul'      => 'Apbdes Footer',
                'key'        => 'apbdes_footer',
                'value'      => '1',
                'keterangan' => 'Apakah akan tampilkan grafik APBDes di halaman muka',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'conf_web',
            ],
            [
                'judul'      => 'Apbdes Footer All',
                'key'        => 'apbdes_footer_all',
                'value'      => '1',
                'keterangan' => 'Apakah akan tampilkan grafik APBDes di semua halaman',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'conf_web',
            ],
            [
                'judul'      => 'Apbdes Manual Input',
                'key'        => 'apbdes_manual_input',
                'value'      => '0',
                'keterangan' => 'Apakah akan tampilkan grafik APBDes yang diinput secara manual',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'conf_web',
            ],
            [
                'judul'      => 'Covid Desa',
                'key'        => 'covid_desa',
                'value'      => '0',
                'keterangan' => 'Apakah akan tampilkan status Covid-19 Desa di halaman muka',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'conf_web',
            ],
            [
                'judul'      => 'Covid RSS',
                'key'        => 'covid_rss',
                'value'      => '0',
                'keterangan' => 'Apakah akan tampilkan RSS Covid-19 di halaman muka',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'conf_web',
            ],
            [
                'judul'      => 'Statistik Chart 3D',
                'key'        => 'statistik_chart_3d',
                'value'      => '1',
                'keterangan' => 'Apakah akan tampilkan Statistik Chart 3D',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'conf_web',
            ],
            [
                'judul'      => 'Sebutan NIP Desa',
                'key'        => 'sebutan_nip_desa',
                'value'      => 'NIPD',
                'keterangan' => 'Pengganti sebutan label niap/nipd',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Layanan Mandiri',
                'key'        => 'layanan_mandiri',
                'value'      => '1',
                'keterangan' => 'Apakah layanan mandiri ditampilkan atau tidak',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'setting_mandiri',
            ],
            [
                'judul'      => 'Ukuran Lebar Bagan',
                'key'        => 'ukuran_lebar_bagan',
                'value'      => '800',
                'keterangan' => 'Ukuran Lebar Bagan (800 / 1200 / 1400)',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => 'class="int"',
                'kategori'   => 'conf_bagan',
            ],
            [
                'judul'      => 'Api Opendk Server',
                'key'        => 'api_opendk_server',
                'value'      => null,
                'keterangan' => 'Alamat Server OpenDK (contoh: https://demodk.opendesa.id)',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'opendk',
            ],
            [
                'judul'      => 'Api Opendk Key',
                'key'        => 'api_opendk_key',
                'value'      => null,
                'keterangan' => 'OpenDK API Key untuk Sinkronisasi Data',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'opendk',
            ],
            [
                'judul'      => 'Api Opendk User',
                'key'        => 'api_opendk_user',
                'value'      => null,
                'keterangan' => 'Email Login Pengguna OpenDK',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'opendk',
            ],
            [
                'judul'      => 'Api Opendk Password',
                'key'        => 'api_opendk_password',
                'value'      => null,
                'keterangan' => 'Password Login Pengguna OpenDK',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'opendk',
            ],
            [
                'judul'      => 'Tgl Data Lengkap',
                'key'        => 'tgl_data_lengkap',
                'value'      => null,
                'keterangan' => 'Atur data tanggal sudah lengkap',
                'jenis'      => 'datetime',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'data_lengkap',
            ],
            [
                'judul'      => 'Tgl Data Lengkap Aktif',
                'key'        => 'tgl_data_lengkap_aktif',
                'value'      => '0',
                'keterangan' => 'Aktif / Non-aktif data tanggal sudah lengkap',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'data_lengkap',
            ],
            [
                'judul'      => 'Api Gform Id Script',
                'key'        => 'api_gform_id_script',
                'value'      => null,
                'keterangan' => 'Script ID untuk Google API',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'setting_analisis',
            ],
            [
                'judul'      => 'Api Gform Credential',
                'key'        => 'api_gform_credential',
                'value'      => null,
                'keterangan' => 'Credential untuk Google API',
                'jenis'      => 'textarea',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'setting_analisis',
            ],
            [
                'judul'      => 'Api Gform Redirect Uri',
                'key'        => 'api_gform_redirect_uri',
                'value'      => 'https://berputar.opendesa.id/index.php/first/get_form_info',
                'keterangan' => 'Redirecet URI untuk Google API',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'setting_analisis',
            ],
            [
                'judul'      => 'Tampilkan Lapak Web',
                'key'        => 'tampilkan_lapak_web',
                'value'      => '1',
                'keterangan' => 'Aktif / Non-aktif Lapak di Halaman Website Url Terpisah',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'lapak',
            ],
            [
                'judul'      => 'Pesan Singkat WA',
                'key'        => 'pesan_singkat_wa',
                'value'      => 'Saya ingin membeli [nama_produk] yang anda tawarkan di Lapak Desa [link_web]',
                'keterangan' => 'Pesan Singkat WhatsApp',
                'jenis'      => 'textarea',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'lapak',
            ],
            [
                'judul'      => 'Banyak Foto Tiap Produk',
                'key'        => 'banyak_foto_tiap_produk',
                'value'      => '3',
                'keterangan' => 'Banyaknya foto tiap produk yang bisa di unggah',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => 'class="int"',
                'kategori'   => 'lapak',
            ],
            [
                'judul'      => 'Jumlah Produk Perhalaman',
                'key'        => 'jumlah_produk_perhalaman',
                'value'      => '10',
                'keterangan' => 'Jumlah produk yang ditampilkan dalam satu halaman',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => 'class="int"',
                'kategori'   => 'lapak',
            ],
            [
                'judul'      => 'Layanan Opendesa Token',
                'key'        => 'layanan_opendesa_token',
                'value'      => null,
                'keterangan' => 'Token pelanggan Layanan OpenDESA',
                'jenis'      => 'textarea',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'pelanggan',
            ],
            [
                'judul'      => 'Footer Surat TTE',
                'key'        => 'footer_surat_tte',
                'value'      => TinyMCE::FOOTER_TTE,
                'keterangan' => 'Footer Surat TTE',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'format_surat',
            ],
            [
                'judul'      => 'Telegram Token',
                'key'        => 'telegram_token',
                'value'      => null,
                'keterangan' => 'Telgram token',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Telegram User Id',
                'key'        => 'telegram_user_id',
                'value'      => null,
                'keterangan' => 'Telgram user id untuk notifikasi ke pengguna',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Tampilan Anjungan',
                'key'        => 'tampilan_anjungan',
                'value'      => '0',
                'keterangan' => 'Pilih tampilan di anjungan pada saat tidak ada aktifitas pada halaman login.',
                'jenis'      => 'option',
                'option'     => json_encode([
                    '0' => 'Tidak Aktif',
                    '1' => 'Slider',
                    '2' => 'Video',
                ]),
                'attribute' => null,
                'kategori'  => 'anjungan',
            ],
            [
                'judul'      => 'Tampilan Anjungan Waktu',
                'key'        => 'tampilan_anjungan_waktu',
                'value'      => '30',
                'keterangan' => 'Atur waktu (detik) kapan tampilan di anjungan akan muncul pada saat tidak ada aktifitas di halaman login.',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => 'class="int"',
                'kategori'   => 'anjungan',
            ],
            [
                'judul'      => 'Tampilan Anjungan Slider',
                'key'        => 'tampilan_anjungan_slider',
                'value'      => null,
                'keterangan' => 'Pilih album yang akan ditampilkan pada anjungan.',
                'jenis'      => 'option',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'anjungan',
            ],
            [
                'judul'      => 'Tampilan Anjungan Video',
                'key'        => 'tampilan_anjungan_video',
                'value'      => null,
                'keterangan' => 'Masukan link video dengan format .mp4 yang akan ditampilkan pada anjungan',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'anjungan',
            ],
            [
                'judul'      => 'Tampilkan Pendaftaran',
                'key'        => 'tampilkan_pendaftaran',
                'value'      => '0',
                'keterangan' => 'Aktifkan / Non Aktifkan Pendaftaran Layanan Mandiri',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'setting_mandiri',
            ],
            [
                'judul'      => 'Tampilan Anjungan Audio',
                'key'        => 'tampilan_anjungan_audio',
                'value'      => '0',
                'keterangan' => 'Apakah audio diaktifkan atau tidak saat video diputar',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'anjungan',
            ],
            [
                'judul'      => 'Branding Desa',
                'key'        => 'branding_desa',
                'value'      => 'LAYANAN MANDIRI',
                'keterangan' => 'Nama Branding Aplikasi Layanan Mandiri Android',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'mobile',
            ],
            [
                'judul'      => 'Tampilkan Kehadiran',
                'key'        => 'tampilkan_kehadiran',
                'value'      => '1',
                'keterangan' => 'Aktif / Non-aktifkan Halaman Website Kehadiran',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'kehadiran',
            ],
            [
                'judul'      => 'IP Adress Kehadiran',
                'key'        => 'ip_adress_kehadiran',
                'value'      => null,
                'keterangan' => 'IP Address Perangkat Kehadiran',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => 'class="ip_address" placeholder="127.0.0.1"',
                'kategori'   => 'kehadiran',
            ],
            [
                'judul'      => 'MAC Adress Kehadiran',
                'key'        => 'mac_adress_kehadiran',
                'value'      => null,
                'keterangan' => 'MAC Address Perangkat Kehadiran',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => 'class="mac_address" placeholder="00:1B:44:11:3A:B7"',
                'kategori'   => 'kehadiran',
            ],
            [
                'judul'      => 'Tahun IDM',
                'key'        => 'tahun_idm',
                'value'      => '2020',
                'keterangan' => 'Default tahun IDM saat pertamakali dibuka',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'status desa',
            ],
            [
                'judul'      => 'Aktifkan SMS',
                'key'        => 'aktifkan_sms',
                'value'      => '0',
                'keterangan' => 'Aktif / Non-aktifkan Kirim SMS ke Warga',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'hubung warga',
            ],
            [
                'judul'      => 'Hubung Warga Balas Otomatis',
                'key'        => 'hubung_warga_balas_otomatis',
                'value'      => 'Terima kasih pesan Anda telah kami terima.',
                'keterangan' => 'Hubung warga isi pesan bawaan balas otomatis',
                'jenis'      => 'textarea',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'hubung warga',
            ],
            [
                'judul'      => 'Latar Kehadiran',
                'key'        => 'latar_kehadiran',
                'value'      => null,
                'keterangan' => 'Latar Kehadiran',
                'jenis'      => 'unggah',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'kehadiran',
            ],
            [
                'judul'      => 'Id Pengunjung Kehadiran',
                'key'        => 'id_pengunjung_kehadiran',
                'value'      => null,
                'keterangan' => 'ID Pengunjung Perangkat Kehadiran',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => 'class="alfanumerik" placeholder="ad02c373c2a8745d108aff863712fe92"',
                'kategori'   => 'kehadiran',
            ],
            [
                'judul'      => 'Header Surat',
                'key'        => 'header_surat',
                'value'      => TinyMCE::HEADER,
                'keterangan' => 'Header Surat',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'format_surat',
            ],
            [
                'judul'      => 'Tinggi Header',
                'key'        => 'tinggi_header',
                'value'      => TinyMCE::TOP,
                'keterangan' => 'Tinggi Header Surat',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'format_surat',
            ],
            [
                'judul'      => 'Footer Surat',
                'key'        => 'footer_surat',
                'value'      => TinyMCE::FOOTER,
                'keterangan' => 'Footer Surat',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'format_surat',
            ],
            [
                'judul'      => 'Tinggi Footer',
                'key'        => 'tinggi_footer',
                'value'      => TinyMCE::BOTTOM,
                'keterangan' => 'Tinggi Footer Surat',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'format_surat',
            ],
            [
                'judul'      => 'Font Surat',
                'key'        => 'font_surat',
                'value'      => 'Arial',
                'keterangan' => 'Font Surat Utama',
                'jenis'      => 'text',
                'option'     => json_encode([
                    'Andale Mono',
                    'Arial',
                    'Arial Black',
                    'Bookman Old Style',
                    'Comic Sans MS',
                    'Courier New',
                    'Georgia',
                    'Helvetica',
                    'Impact',
                    'Tahoma',
                    'Times New Roman',
                    'Trebuchet MS',
                    'Verdana',
                ]),
                'attribute' => null,
                'kategori'  => 'format_surat',
            ],
            [
                'judul'      => 'Jenis Peta',
                'key'        => 'jenis_peta',
                'value'      => '5',
                'keterangan' => 'Jenis peta yang digunakan',
                'jenis'      => 'option',
                'option'     => json_encode([
                    '1' => 'OpenStreetMap',
                    '2' => 'OpenStreetMap H.O.T',
                    '3' => 'Mapbox Streets',
                    '4' => 'Mapbox Satellite',
                    '5' => 'Mapbox Satellite-Street',
                ]),
                'attribute' => null,
                'kategori'  => 'peta',
            ],
            [
                'judul'      => 'Verifikasi Kades',
                'key'        => 'verifikasi_kades',
                'value'      => '0',
                'keterangan' => 'Verifikasi Surat Oleh Kepala Desa',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'alur_surat',
            ],
            [
                'judul'      => 'Verifikasi Sekdes',
                'key'        => 'verifikasi_sekdes',
                'value'      => '0',
                'keterangan' => 'Verifikasi Surat Oleh Sekretaris daerah',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'alur_surat',
            ],
            [
                'judul'      => 'Notifikasi Koneksi',
                'key'        => 'notifikasi_koneksi',
                'value'      => '0',
                'keterangan' => 'Ingatkan jika aplikasi tidak terhubung dengan internet.',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Tampil Luas Peta',
                'key'        => 'tampil_luas_peta',
                'value'      => '0',
                'keterangan' => 'Tampilkan Luas Wilayah Pada Peta',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'TTE',
                'key'        => 'tte',
                'value'      => '0',
                'keterangan' => 'TTE - Aktifkan Modul TTE',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'tte',
            ],
            [
                'judul'      => 'TTE Api',
                'key'        => 'tte_api',
                'value'      => null,
                'keterangan' => 'TTE - URL API TTE',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'tte',
            ],
            [
                'judul'      => 'TTE Username',
                'key'        => 'tte_username',
                'value'      => null,
                'keterangan' => 'TTE - Username untuk TTE',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'tte',
            ],
            [
                'judul'      => 'TTE Password',
                'key'        => 'tte_password',
                'value'      => null,
                'keterangan' => 'TTE - Password untuk TTE',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'tte',
            ],
            [
                'judul'      => 'Kode Desa BPS',
                'key'        => 'kode_desa_bps',
                'value'      => '3524190011',
                'keterangan' => 'Kode Desa BPS (Dapat di cek di https://sig.bps.go.id/bridging-kode)',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'status sdgs',
            ],
            [
                'judul'      => 'Min Zoom Peta',
                'key'        => 'min_zoom_peta',
                'value'      => '1',
                'keterangan' => 'Minimal pembesaran wilayah pada peta',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => 'class="int"',
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Max Zoom Peta',
                'key'        => 'max_zoom_peta',
                'value'      => '30',
                'keterangan' => 'Maksimal pembesaran wilayah pada peta',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => 'class="int"',
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Notifikasi Pengajuan Surat',
                'key'        => 'notifikasi_pengajuan_surat',
                'value'      => 'Segera cek Halaman Admin, penduduk atas nama [nama_penduduk] telah mengajukan [judul_surat] melalui [melalui] pada tanggal [tanggal] TERIMA KASIH.',
                'keterangan' => 'Pesan notifikasi pengajuan surat',
                'jenis'      => 'textarea',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Anjungan Artikel',
                'key'        => 'anjungan_artikel',
                'value'      => null,
                'keterangan' => 'Pengaturan artikel untuk anjungan',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'anjungan',
            ],
            [
                'judul'      => 'Visual TTE',
                'key'        => 'visual_tte',
                'value'      => '0',
                'keterangan' => 'Visual Tanda Tangan TTE',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'tte',
            ],
            [
                'judul'      => 'Visual TTE Gambar',
                'key'        => 'visual_tte_gambar',
                'value'      => null,
                'keterangan' => 'Url Gambar Visual TTE',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'tte',
            ],
            [
                'judul'      => 'Visual TTE Weight',
                'key'        => 'visual_tte_weight',
                'value'      => '100',
                'keterangan' => 'Lebar Gambar Visual TTE',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'tte',
            ],
            [
                'judul'      => 'Visual TTE Height',
                'key'        => 'visual_tte_height',
                'value'      => '100',
                'keterangan' => 'Tinggi Gambar Visual TTE',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'tte',
            ],
            [
                'judul'      => 'Anjungan Teks Berjalan',
                'key'        => 'anjungan_teks_berjalan',
                'value'      => null,
                'keterangan' => 'Pengaturan teks berjalan untuk anjungan',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'anjungan',
            ],
            [
                'judul'      => 'Anjungan Profil',
                'key'        => 'anjungan_profil',
                'value'      => '3',
                'keterangan' => 'Pengaturan profil desa untuk anjungan',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'anjungan',
            ],
            [
                'judul'      => 'Anjungan Slide',
                'key'        => 'anjungan_slide',
                'value'      => null,
                'keterangan' => 'Pengaturan profil slide untuk anjungan',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'anjungan',
            ],
            [
                'judul'      => 'Anjungan Video',
                'key'        => 'anjungan_video',
                'value'      => null,
                'keterangan' => 'Pengaturan profil video untuk anjungan',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'anjungan',
            ],
            [
                'judul'      => 'Anjungan Youtube',
                'key'        => 'anjungan_youtube',
                'value'      => 'https://www.youtube.com/embed/PuxiuH-YUF4',
                'keterangan' => 'Pengaturan profil video youtube untuk anjungan',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'anjungan',
            ],
            [
                'judul'      => 'Anjungan Layar',
                'key'        => 'anjungan_layar',
                'value'      => '1',
                'keterangan' => 'Pengaturan jenis layar anjungan',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'anjungan',
            ],
            [
                'judul'      => 'Sebutan Pemerintah Desa',
                'key'        => 'sebutan_pemerintah_desa',
                'value'      => 'Pemerintah ' . ucwords(SettingAplikasiModel::where('key', 'sebutan_desa')->first()->value ?? 'desa'),
                'keterangan' => 'Sebutan Pemerintah Desa',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'Pemerintah Desa',
            ],
            [
                'judul'      => 'Latar Login Mandiri',
                'key'        => 'latar_login_mandiri',
                'value'      => 'latar_login_mandiri.jpg',
                'keterangan' => 'Latar untuk Login Layanan Mandiri',
                'jenis'      => 'unggah',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'latar',
            ],
            [
                'judul'      => 'Latar Website',
                'key'        => 'latar_website',
                'value'      => 'latar_website.jpg',
                'keterangan' => 'Latar untuk login ke halaman website',
                'jenis'      => 'unggah',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'latar',
            ],
            [
                'judul'      => 'Latar Login Admin',
                'key'        => 'latar_login',
                'value'      => 'latar_login.jpg',
                'keterangan' => 'Latar untuk login ke halaman admin',
                'jenis'      => 'unggah',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'latar',
            ],
            [
                'judul'      => 'Inspect Element',
                'key'        => 'inspect_element',
                'value'      => '1',
                'keterangan' => 'Mengaktifkan inspect element pada halaman website',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Warna Tema',
                'key'        => 'warna_tema',
                'value'      => (DB::table('setting_aplikasi')->where('key', 'warna_tema')->first()->value ?: config_item('warna_tema')) ?: SettingAplikasiModel::WARNA_TEMA,
                'keterangan' => 'Warna tema untuk halaman website',
                'jenis'      => 'color',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'openkab',
            ],
            [
                'judul'      => 'Rentang Waktu Kehadiran',
                'key'        => 'rentang_waktu_kehadiran',
                'value'      => '10',
                'keterangan' => 'Rentang waktu kehadiran ketika keluar. (satuan: menit)',
                'jenis'      => 'input',
                'option'     => null,
                'attribute'  => 'class="bilangan required" placeholder="10" min="0" type="number"',
                'kategori'   => 'kehadiran',
            ],
            [
                'judul'      => 'Tampilkan Tombol Peta',
                'key'        => 'tampilkan_tombol_peta',
                'value'      => '["Statistik Penduduk", "Statistik Bantuan", "Aparatur Desa", "Kepala Wilayah"]',
                'keterangan' => 'Tampilkan tombol di peta',
                'jenis'      => 'multiple-option',
                'option'     => '["Statistik Penduduk", "Statistik Bantuan", "Aparatur Desa", "Kepala Wilayah"]',
                'attribute'  => null,
                'kategori'   => 'peta',
            ],
            [
                'judul'      => 'Margin Global',
                'key'        => 'surat_margin',
                'value'      => '{"kiri":1.78,"atas":0.63,"kanan":1.78,"bawah":1.37}',
                'keterangan' => 'Margin Global untuk surat',
                'jenis'      => null,
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'format_surat',
            ],
            [
                'judul'      => 'Kunci Pilihan Tema',
                'key'        => 'lock_theme',
                'value'      => '1',
                'keterangan' => '1. bisa ganti tema, 0. tidak bisa pilih tema',
                'jenis'      => 'option',
                'option'     => '{"0": "Kunci","1": "Bebas pilih"}',
                'attribute'  => null,
                'kategori'   => 'openkab',
            ],
            [
                'judul'      => 'Buku Tamu Kamera',
                'key'        => 'buku_tamu_kamera',
                'value'      => '1',
                'keterangan' => 'Gunakan kamera untuk proses registrasi',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'buku-tamu',
            ],
            [
                'judul'      => 'Link Feed',
                'key'        => 'link_feed',
                'value'      => 'https:\\/\\/www.covid19.go.id\\/feed\\/',
                'keterangan' => 'Alamat Feed yang digunakan <code>(contoh: https:\\/\\/www.covid19.go.id\\/feed\\/)<\\/code>',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'conf_web',
            ],
            [
                'judul'      => 'Kode Isian data kosong',
                'key'        => 'ganti_data_kosong',
                'value'      => '-',
                'keterangan' => 'Bawaan jika kode isian memiliki data kosong',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'format_surat',
            ],
            [
                'judul'      => 'Telegram Notifikasi',
                'key'        => 'telegram_notifikasi',
                'value'      => '0',
                'keterangan' => 'Aktif atau nonaktifkan notifikasi telegram',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Non Aktifkan Surat RTF',
                'key'        => 'nonaktifkan_rtf',
                'value'      => '0',
                'keterangan' => 'Aktif \\/ Non-aktifkan Surat RTF',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'pengaturan-surat',
            ],
            [
                'judul'      => 'Format Tanggal Surat',
                'key'        => 'format_tanggal_surat',
                'value'      => 'd F Y',
                'keterangan' => 'Format tanggal pada kode isian surat.',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'format_surat',
            ],
            [
                'judul'      => 'Form penduduk luar [desa]',
                'key'        => 'form_penduduk_luar',
                'value'      => '{"2":{"title":"PENDUDUK LUAR [desa]","input":"nama,no_ktp"},"3":{"title":"PENDUDUK LUAR [desa] (LENGKAP)","input":"nama,no_ktp,tempat_lahir,tanggal_lahir,alamat,agama,pekerjaan,warga_negara"}}',
                'keterangan' => 'Form ini akan tampil jika surat dipilih menggunakan penduduk luar [desa]',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'form_surat',
            ],
            [
                'judul'      => 'Email Notifikasi',
                'key'        => 'email_notifikasi',
                'value'      => '0',
                'keterangan' => 'Aktif atau nonaktifkan notifikasi email',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'email',
            ],
            [
                'judul'      => 'Email protokol',
                'key'        => 'email_protocol',
                'value'      => 'smtp',
                'keterangan' => 'Email protokol, misal : SMTP',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'email',
            ],
            [
                'judul'      => 'Email Host',
                'key'        => 'email_smtp_host',
                'value'      => null,
                'keterangan' => 'Email host',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'email',
            ],
            [
                'judul'      => 'Email Username',
                'key'        => 'email_smtp_user',
                'value'      => null,
                'keterangan' => 'Email username',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'email',
            ],
            [
                'judul'      => 'Email Password',
                'key'        => 'email_smtp_pass',
                'value'      => null,
                'keterangan' => 'Email password',
                'jenis'      => 'password',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'email',
            ],
            [
                'judul'      => 'Email Port',
                'key'        => 'email_smtp_port',
                'value'      => null,
                'keterangan' => 'Email port',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'email',
            ],
            [
                'judul'      => 'Google Recaptcha Site Key',
                'key'        => 'google_recaptcha_site_key',
                'value'      => '',
                'keterangan' => 'Site key google recaptcha',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Google Recaptcha Secret Key',
                'key'        => 'google_recaptcha_secret_key',
                'value'      => '',
                'keterangan' => 'Secret key google recaptcha',
                'jenis'      => 'text',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
            [
                'judul'      => 'Google Recaptcha',
                'key'        => 'google_recaptcha',
                'value'      => 0,
                'keterangan' => 'Aktif atau nonaktifkan google recaptcha',
                'jenis'      => 'boolean',
                'option'     => null,
                'attribute'  => null,
                'kategori'   => 'sistem',
            ],
        ];
    }
}
